 ; Ŀ
 ;   Asc - read a text file into a drawing.                                
 ;   Copyright 1996, 2001, 2005, 2010 by Rocket Software Ltd.              
 ;   If you wouldn't understand, then you don't have to use Asc.           
 ; 

 ; Ŀ
 ;   Subroutine Alpha - increment a character string.                      
 ;   Takes one argument, a string.  Returns the incremented version.       
 ; 
 (DEFUN ALPHA (cname / pos char base cname cnamp chasci)
  (setq pos (strlen cname))
  (while (and (>= pos 1)
              (setq char (substr cname pos 1))
              (<= 90 (ascii char)))
         (setq pos (1- pos)))
 ; Ŀ
 ;   If no non-z characters were found, set all to 0 and add an 0 to the   
 ;   left end of the string.                                               
 ; 
  (cond ((= pos 0)
         (setq base "")
         (repeat (1+ (strlen cname))
                 (setq base (strcat base "0")))
         (setq cname base))
 ; Ŀ
 ;   If a non-Z was found, everything to the right of it becomes a 0, and  
 ;   it is incremented.                                                    
 ; 
        (T (setq cnamp cname)
           (setq cname (strcat (substr cnamp 1 (1- pos))))
           (setq char (chr (1+ (ascii (substr cnamp pos 1)))))
           (setq chasci (ascii char))
           (if (and (>= chasci 58) (<= chasci 64))
               (setq char "A"))
           (setq base "")
           (repeat (strlen (substr cnamp (1+ pos)))
                   (setq base (strcat base "0")))
           (setq cname (strcat cname char base))))
 cname)
 ; Ŀ
 ;   Alpha end.                                                            
 ; 

 ; Ŀ
 ;   Misps: get a scale factor: 1 in PS, Dimscale in MS or a vport.        
 ;   If the global variable Scalps is t the PS scale is also dimscale.     
 ; 
 (DEFUN MISPS (/ scaalf scapa)
  (setq scaalf (getvar "dimscale"))
  (if (= scaalf 0) (setq scaalf 1))  ; if dimscale is zero, make it 1
  (setq scapa (wasp))
  (cond (scalps scaalf)  ; scalps is set so always dimscale
        ((= scapa 1)     ; ms
         scaalf)
        ((= scapa 2)     ; ps
         1)
        ((= scapa 3)     ; viewport in ps
         scaalf)
        (t scaalf)))     ; no idea - use dimscale
 ; Ŀ
 ;   Misps end.                                                            
 ; 

 ; Ŀ
 ;   MtStr - see if a string contains only spaces.                         
 ;   Arguments: Str, the string.                                           
 ;   Returns T if the string was spaces only, otherwise Nil.               
 ; 
 (DEFUN MTSTR (strp)
  (while (and (/= strp "") (= (substr strp 1 1) " "))
         (setq strp (substr strp 2)))
  (if (= strp "") T ()))
 ; Ŀ
 ;   MtStr end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Nosp - remove leading and trailing spaces from a string.   
 ;   Takes one arguments, the string.                                      
 ;   Returns a list: (Number_of_spaces  String  Number_of_spaces).         
 ; 
 (DEFUN NOSP (str / lead lag len)
  (setq lead 0)
  (setq lag 0)
  (while (and (/= str "") (= (substr str 1 1) " "))
         (setq lead (1+ lead))
         (setq str (substr str 2)))
  (while (and (/= str "") (= (substr str (setq len (strlen str))) " "))
         (setq lag (1+ lag))
         (setq str (substr str 1 (1- len))))
 (list lead str lag))
 ; Ŀ
 ;   Nosp end.                                                             
 ; 

 ; Ŀ
 ;   Rile - find the width of a text entity by converting it to right      
 ;   justification and measuring the distance between its ten and eleven   
 ;   points.                                                               
 ;   Arguments: Str - the string to measure.                               
 ;              Enam - the ename of an entity having the properties        
 ;              which we require in the string.                            
 ;   Calls nothing, returns a distance.                                    
 ;   Not as simple as the textbox function, but doesn't return zero as     
 ;   the width of a space, which textbox now does - this must be a new     
 ;   paradigm or something.                                                
 ;   This returns a length of zero for an empty string, by the way.        
 ; 
 (DEFUN RILE (str enam / entt typp dist)
  (setq entt (entget enam))
  (if (member (setq typp (cdr (assoc 0 entt))) '("TEXT" "ATTDEF"))
      (progn
           (command ".copy" enam "" "0,0" "0,0")
           (setq entt (entget (setq enam (entlast))))
           (if (= typp "TEXT")
               (setq entt (subst (cons 1 str) (assoc 1 entt) entt))
               (setq entt (subst (cons 2 str) (assoc 2 entt) entt)))
           (entmod (subst (cons 72 2) (assoc 72 entt) entt))    ; change
           (setq entt (entget enam))                 ; get the changed edata
           (setq dist (distance (cdr (assoc 10 entt)) (cdr (assoc 11 entt))))
           (entdel enam)))
 dist)
 ; Ŀ
 ;   Rile end.                                                             
 ; 

 ; Ŀ
 ;   Smop - install a string in a text entity, move it to a point.         
 ;   Arguments: Enam, the text entity name.                                
 ;              Str, the string.                                           
 ;              Pa, the point.                                             
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN SMOP (enam str pa / entt ten)
  (setq entt (entget enam))
  (setq entt (subst (cons 1 str) (assoc 1 entt) entt))
  (entmod entt)
  (setq entt (entget enam))
  (setq ten (cdr (assoc 10 entt)))
  (command ".move" enam "" ten pa)
 (princ))
 ; Ŀ
 ;   Smop end.                                                             
 ; 

 ; Ŀ
 ;   Straf - remove leading spaces from a text string, don't change it's   
 ;   apparent position.                                                    
 ;   Takes one argument, an entity name.                                   
 ;   Calls Nosp, Rile, Mtstr, and Smop.                                    
 ;   Returns nothing.  Assumes that the string is left justified.          
 ; 
 (DEFUN STRAF (enam / tent str pll rota strlis lead pos)
  (setq tent (entget enam))
  (setq str (cdr (assoc 1 tent)))
  (setq pll (cdr (assoc 10 tent)))
  (setq rota (cdr (assoc 50 tent)))
  (setq strlis (nosp str))
  (setq str (cadr strlis))
  (setq lead "")
  (repeat (car strlis) (setq lead (strcat lead " ")))
 ; Ŀ
 ;   Get the lower left point of the text after the spaces.                
 ; 
  (setq pos (polar pll rota (rile lead enam)))
 ; Ŀ
 ;   Install the string, move the text to the point.                       
 ; 
  (if (not (mtstr str)) (smop enam str pos))
 (princ))
 ; Ŀ
 ;   Straf end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Bmake: make a block of an ss, insert it.                   
 ;   Arguments, ss, a selection set.                                       
 ;              Bnam, the desired block name.                              
 ;              Pa, a point.                                               
 ;   Calls nothing, returns mothing.                                       
 ; 
 (DEFUN BMAKE (ss bnam pa)
  (command ".block" bnam pa ss "")
  (command ".insert" bnam pa 1 "" 0)
 (princ))
 ; Ŀ
 ;   Subroutine Bmake end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Wasp - are we in the Model Space Tab, Paper Space, or      
 ;   a viewport in Paper Space?                                            
 ;   Brooks no Arguments.                                                  
 ;   Calls nothing.                                                        
 ;   Returns: 1 - Model space.                                             
 ;            2 - Paper space.                                             
 ;            3 - A Viewport in Paper Space.                               
 ; 
 (DEFUN WASP ()
  (cond ((= (getvar "tilemode") 1) 1)
        ((= (getvar "cvport") 1) 2)
        (t 3)))
 ; Ŀ
 ;   Wasp end.                                                             
 ; 

 ; Ŀ
 ;   Asc.                                                                  
 ; 
 (DEFUN C:ASC (/ styl osm *error* filnam pa fn linn strlst ss num str enam
                                               elast lasttx bnamn bnamb suff)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq styl (getvar "textstyle"))
  (setq osm (getvar "osmode"))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk)
  (if shk (write-line shk))
  (setvar "textstyle" styl)
  (setvar "osmode" osm)
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   Load the monospaced font, make it the current one.                    
 ; 
;  (command "style" "mono" "monotxt" "" "1" "" "" "" "")  ; acad font
  (command "style" "mono" "monos.ttf" "" "1" "" "" "")    ; truetype
 ; Ŀ
 ;   Get a filename.                                                       
 ; 
  (setq filnam (getfiled "Ascii Text File" "" "" 0))
 ; Ŀ
 ;   Get a start point.                                                    
 ; 
  (setq pa (getpoint "Upper left point: "))
 ; Ŀ
 ;   Open the file, read the file into a list of strings, close the file.  
 ; 
  (setq fn (open filnam "r"))
  (while (setq linn (read-line fn))
         (setq strlst (cons linn strlst)))
  (close fn)
  (setq strlst (reverse strlst))
 ; Ŀ
 ;   Draw the column of text.                                              
 ;   If the first string is empty then no text entity will be created and  
 ;   the last entity from before the program was started will be added to  
 ;   the ss.  To prevent this, compare each (entlast) to the original      
 ;   last entity and if they are the same entity then don't add it.        
 ; 
  (setq elast (entlast))
  (setvar "osmode" 0)
  (command "text" pa (misps) 0 (car strlst))
  (if (not (equal (setq lasttx (entlast)) elast)) ; if there is a new entity
      (setq ss (ssadd lasttx))                    ; add to new ss
      (setq ss (ssadd)))                ; no new entity, so make an empty ss
  (setq num 1)
  (while (setq str (nth num strlst))
         (setq num (1+ num))
         (command "text" "" str)
         (if (not (equal (setq lasttx (entlast)) elast))
             (ssadd lasttx ss)))
 ; Ŀ
 ;   Remove leading and trailing spaces.                                   
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (straf enam))
 ; Ŀ
 ;   Block the new text lines.  First make a block name.                   
 ; 
  (setq bnamn (vl-filename-base filnam))
  (setq bnamn (strcat (strcase (substr bnamn 1 1))
                      (strcase (substr bnamn 2) t))) 
 ; Ŀ
 ;   Save a copy of the name in case need to use it as a base.             
 ; 
  (setq bnamb bnamn)
 ; Ŀ
 ;   See if it is unique, if not then increment it.                        
 ; 
  (while (tblsearch "block" bnamn)
         (if (null suff)
             (setq suff "0")
             (setq suff (alpha suff)))
         (setq bnamn (strcat bnamb suff)))
 ; Ŀ
 ;   Make the block.                                                       
 ; 
  (bmake ss bnamn pa)
 ; Ŀ
 ;   Restore sysvars, end.                                                 
 ; 
  (*error* ())
 (princ))